class X2Effect_BioticRegen extends X2Effect_Persistent;

var int HealAmount;
var int HealLimit;

function RegisterForEvents(XComGameState_Effect EffectGameState)
{
	local X2EventManager EventMgr;
	local XComGameState_Unit EffectTargetUnit;
	local XComGameStateHistory History;
	local Object EffectObj;

	History = `XCOMHISTORY;
	EventMgr = `XEVENTMGR;

	EffectObj = EffectGameState;
	EffectTargetUnit = XComGameState_Unit(History.GetGameStateForObjectID(EffectGameState.ApplyEffectParameters.TargetStateObjectRef.ObjectID));

	// Register for the required events
	EventMgr.RegisterForEvent(EffectObj, 'BioticRegainBarrier', EffectGameState.TriggerAbilityFlyover, ELD_OnStateSubmitted,, EffectTargetUnit);
}

function bool RegenerationTicked(X2Effect_Persistent PersistentEffect, const out EffectAppliedData ApplyEffectParameters, XComGameState_Effect kNewEffectState, XComGameState NewGameState, bool FirstApplication)
{
	local XComGameState_Unit OldTargetState, NewTargetState;
	local int AmountToHeal;
	local X2EventManager EventMgr;
	local XComGameState_Ability AbilityState;

	OldTargetState = XComGameState_Unit(`XCOMHISTORY.GetGameStateForObjectID(ApplyEffectParameters.TargetStateObjectRef.ObjectID));


	// If no value tracking for health regenerated is set, heal for the default amount
	AmountToHeal = HealAmount;

	if(OldTargetState.GetCurrentStat(eStat_PsiOffense) >= 75)
		AmountToHeal += (OldTargetState.GetCurrentStat(eStat_PsiOffense) / 75);

	if((OldTargetState.GetCurrentStat(eStat_ShieldHP) + AmountToHeal) > HealLimit)
	{
		AmountToHeal = (OldTargetState.GetCurrentStat(eStat_PsiOffense) + AmountToHeal) - HealLimit;
	}

	// Perform the heal IF shield HP is below this:
	if(int(OldTargetState.GetCurrentStat(eStat_ShieldHP)) < HealLimit && int(OldTargetState.GetCurrentStat(eStat_ShieldHP)) > 0)
	{
		NewTargetState = XComGameState_Unit(NewGameState.CreateStateObject(OldTargetState.Class, OldTargetState.ObjectID));
		NewTargetState.ModifyCurrentStat(estat_ShieldHP, AmountToHeal);
		NewGameState.AddStateObject(NewTargetState);
	}

	
	if(OldTargetState.GetCurrentStat(eStat_ShieldHP) < 1)
	{
			NewTargetState = XComGameState_Unit(NewGameState.CreateStateObject(OldTargetState.Class, OldTargetState.ObjectID));
			NewGameState.AddStateObject(NewTargetState);
			AbilityState = XComGameState_Ability(NewGameState.GetGameStateForObjectID(ApplyEffectParameters.AbilityStateObjectRef.ObjectID));
			EventMgr = `XEVENTMGR;
			EventMgr.TriggerEvent('BioticRegainBarrier', AbilityState, NewTargetState, NewGameState); //tell the regain barrier ability to fire
	}

	return false;
}

simulated function AddX2ActionsForVisualization_Tick(XComGameState VisualizeGameState, out VisualizationActionMetadata Buildtrack, const int TickIndex, XComGameState_Effect EffectState)
{
	local XComGameState_Unit OldUnit, NewUnit;
	local X2Action_PlaySoundAndFlyOver SoundAndFlyOver;
	local int Healed;

	OldUnit = XComGameState_Unit(BuildTrack.StateObject_OldState);
	NewUnit = XComGameState_Unit(BuildTrack.StateObject_NewState);

	Healed = NewUnit.GetCurrentStat(eStat_ShieldHP) - OldUnit.GetCurrentStat(eStat_ShieldHP);
	
	if( Healed > 0 )
	{
		SoundAndFlyOver = X2Action_PlaySoundAndFlyOver(class'X2Action_PlaySoundAndFlyOver'.static.AddToVisualizationTree(BuildTrack, VisualizeGameState.GetContext()));
		SoundAndFlyOver.SetSoundAndFlyOverParameters(None, "+" $ Healed, '', eColor_Good);
	}
}

defaultproperties
{
	EffectName="BioticRegen"
	EffectTickedFn=RegenerationTicked
}